/**
 * BooleanParser 29.03.2012
 *
 * @author Philipp Haussleiter
 *
 */
package de.javastream.javassh.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BooleanPP implements ProcessParser {

    private boolean result = true;
    private final static Logger LOG = Logger.getLogger(BooleanPP.class.getName());

    public void parse(BufferedReader bufferedreader) {
        try {
            String line;
            while ((line = bufferedreader.readLine()) != null) {
                if (line.trim().equals("0")) {
                    result = false;
                }
            }
        } catch (IOException ex) {
            LOG.log(Level.SEVERE, ex.getLocalizedMessage());
        }
    }

    public boolean getResult() {
        return result;
    }
}
