/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfwriter.compress;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdfwriter.compress.COSObjectPool;
import org.apache.pdfbox.pdfwriter.compress.COSWriterObjectStream;
import org.apache.pdfbox.pdfwriter.compress.CompressParameters;
import org.apache.pdfbox.pdmodel.PDDocument;

public class COSWriterCompressionPool {
    public static final float MINIMUM_SUPPORTED_VERSION = 1.6f;
    private final PDDocument document;
    private final CompressParameters parameters;
    private final COSObjectPool objectPool;
    private final List<COSObjectKey> topLevelObjects = new ArrayList<COSObjectKey>();
    private final List<COSObjectKey> objectStreamObjects = new ArrayList<COSObjectKey>();
    private final List<COSBase> allDirectObjects = new ArrayList<COSBase>();

    public COSWriterCompressionPool(PDDocument document, CompressParameters parameters) throws IOException {
        this.document = document;
        this.parameters = parameters != null ? parameters : new CompressParameters();
        this.objectPool = new COSObjectPool(document.getDocument().getHighestXRefObjectNumber());
        COSDocument cosDocument = document.getDocument();
        COSDictionary trailer = cosDocument.getTrailer();
        this.addStructure(trailer.getItem(COSName.ROOT));
        this.addStructure(trailer.getItem(COSName.INFO));
        Collections.sort(this.objectStreamObjects);
        Collections.sort(this.topLevelObjects);
    }

    private COSBase addObjectToPool(COSObjectKey key, COSBase base) {
        COSBase current;
        COSBase cOSBase = current = base instanceof COSObject ? ((COSObject)base).getObject() : base;
        if (current == null || key != null && this.objectPool.contains(key) || key == null && this.objectPool.contains(current)) {
            return current;
        }
        if (key != null && key.getGeneration() != 0 || current instanceof COSStream || this.document.getEncryption() != null && current == this.document.getEncryption().getCOSObject() || current == this.document.getDocument().getTrailer().getCOSDictionary(COSName.ROOT)) {
            COSObjectKey actualKey = this.objectPool.put(key, current);
            if (actualKey == null) {
                return current;
            }
            this.topLevelObjects.add(actualKey);
            return current;
        }
        COSObjectKey actualKey = this.objectPool.put(key, current);
        if (actualKey == null) {
            return current;
        }
        this.objectStreamObjects.add(actualKey);
        return current;
    }

    private void addStructure(COSBase current) throws IOException {
        COSBase base = current;
        if (current instanceof COSStream || current instanceof COSDictionary && !current.isDirect()) {
            base = this.addObjectToPool(base.getKey(), current);
        } else if (current instanceof COSObject && (base = ((COSObject)current).getObject()) != null) {
            base = this.addObjectToPool(current.getKey(), current);
        }
        if (base instanceof COSArray) {
            this.addElements(((COSArray)base).iterator());
        } else if (base instanceof COSDictionary) {
            this.addElements(((COSDictionary)base).getValues().iterator());
        }
    }

    private void addElements(Iterator<COSBase> elements) throws IOException {
        while (elements.hasNext()) {
            COSObject cosObject;
            COSBase value = elements.next();
            if (value instanceof COSArray || value instanceof COSDictionary && !this.allDirectObjects.contains(value)) {
                this.allDirectObjects.add(value);
                this.addStructure(value);
                continue;
            }
            if (!(value instanceof COSObject) || (cosObject = (COSObject)value).getKey() != null && this.objectPool.contains(cosObject.getKey()) || cosObject.getObject() == null) continue;
            this.addStructure(value);
        }
    }

    public List<COSObjectKey> getTopLevelObjects() {
        return this.topLevelObjects;
    }

    public List<COSObjectKey> getObjectStreamObjects() {
        return this.objectStreamObjects;
    }

    public boolean contains(COSBase object) {
        return this.objectPool.contains(object);
    }

    public COSObjectKey getKey(COSBase object) {
        return this.objectPool.getKey(object);
    }

    public COSBase getObject(COSObjectKey key) {
        return this.objectPool.getObject(key);
    }

    public long getHighestXRefObjectNumber() {
        return this.objectPool.getHighestXRefObjectNumber();
    }

    public List<COSWriterObjectStream> createObjectStreams() {
        ArrayList<COSWriterObjectStream> objectStreams = new ArrayList<COSWriterObjectStream>();
        COSWriterObjectStream objectStream = null;
        for (int i = 0; i < this.objectStreamObjects.size(); ++i) {
            COSObjectKey key = this.objectStreamObjects.get(i);
            if (objectStream == null || i % this.parameters.getObjectStreamSize() == 0) {
                objectStream = new COSWriterObjectStream(this);
                objectStreams.add(objectStream);
            }
            objectStream.prepareStreamObject(key, this.objectPool.getObject(key));
        }
        return objectStreams;
    }
}

