/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.impl.bundle.bindex;

import aQute.bnd.annotation.component.Component;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.impl.bundle.bindex.Index;
import org.osgi.impl.bundle.obr.resource.RepositoryImpl;
import org.osgi.impl.bundle.obr.resource.ResourceImpl;
import org.osgi.impl.bundle.obr.resource.Tag;
import org.osgi.service.bindex.BundleIndexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class BundleIndexerImpl
extends Index
implements BundleIndexer {
    OutputStream out;

    public synchronized void index(Set<File> jarFiles, OutputStream out, Map<String, String> config) throws Exception {
        if (jarFiles == null || jarFiles.isEmpty()) {
            throw new IllegalArgumentException("No input jar provided");
        }
        if (out == null) {
            throw new IllegalArgumentException("No output stream provided");
        }
        this.out = out;
        if (config != null) {
            String v = null;
            v = config.get("repository.name");
            if (v != null) {
                this.name = v;
            }
            if ((v = config.get("stylesheet")) != null) {
                this.stylesheet = v;
            }
            if ((v = config.get("url.template")) != null) {
                this.urlTemplate = v;
            }
            if ((v = config.get("root.url")) != null) {
                this.root = new URL(v);
            }
            if ((v = config.get("license.url")) != null) {
                this.licenseURL = new URL(v);
            }
        }
        if (this.root == null) {
            this.root = new File("").getAbsoluteFile().toURI().toURL();
        }
        this.repository = new RepositoryImpl(this.root);
        HashSet<ResourceImpl> resources = new HashSet<ResourceImpl>();
        for (File f : jarFiles) {
            super.recurse(resources, f);
        }
        ArrayList<ResourceImpl> sorted = new ArrayList<ResourceImpl>(resources);
        Collections.sort(sorted, new Comparator<ResourceImpl>(){

            @Override
            public int compare(ResourceImpl r1, ResourceImpl r2) {
                String s1 = BundleIndexerImpl.this.getName(r1);
                String s2 = BundleIndexerImpl.this.getName(r2);
                return s1.compareTo(s2);
            }
        });
        Tag tag = super.doIndex(sorted);
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(out, "UTF-8"));
        try {
            pw.println("<?xml version='1.0' encoding='utf-8'?>");
            pw.println("<?xml-stylesheet type='text/xsl' href='" + this.stylesheet + "'?>");
            tag.print(0, pw);
        }
        finally {
            pw.close();
        }
    }
}

