/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.manager.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bundlebee.manager.impl.Activator;
import org.bundlebee.manager.impl.ManagerImpl;
import org.bundlebee.remoteservicecall.Callee;
import org.bundlebee.remoteservicecall.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceMethodCallServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceMethodCallServlet.class);
    private static final int DEFAULT_SERVICE_RESPONSE_BUFFER_SIZE = 65536;
    private static final String BUFFER_KEY = "org.bundlebee.manager.service.buffer";
    private int responseBufferSize = new Integer(System.getProperty("org.bundlebee.manager.service.buffer", "65536"));
    private ManagerImpl manager;

    public ServiceMethodCallServlet(ManagerImpl manager) {
        this.manager = manager;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.setResponseBufferSize(response, this.responseBufferSize);
        Result r = Callee.executeCall((InputStream)request.getInputStream(), (OutputStream)response.getOutputStream(), this.manager.getBundleContext());
        switch (r.getType()) {
            case REGULAR: 
            case TARGETEXCEPTION: {
                response.setStatus(200);
                break;
            }
            case CALLRUNTIMEXCEPTION: 
            case SERVICEEXCEPTION: {
                response.setStatus(500);
            }
        }
    }

    private void setResponseBufferSize(HttpServletResponse response, int size) {
        block2: {
            try {
                response.getClass().getMethod("setBufferSize", Integer.TYPE).invoke((Object)response, size);
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug(Activator.BUNDLE_MARKER, "Failed to set response buffer size. This may be normal, since it is a Servlet Spec > 2.1 feature and does not have to be supported: " + e);
            }
        }
    }
}

