/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.examples.fractal;

import java.awt.image.WritableRaster;
import javax.swing.JFrame;

class Calculator
extends Thread {
    WritableRaster raster;
    int sizex;
    int sizey;
    double startx;
    double starty;
    double width;
    double height;
    double z;
    double zi;
    int[] black;
    int[] red;
    Object[] colors;
    JFrame parent;
    boolean done;

    public Calculator(int sx, int sy, WritableRaster r, JFrame p) {
        int[] color;
        int i;
        this.parent = p;
        this.raster = r;
        this.sizex = sx;
        this.sizey = sy;
        this.z = 0.0;
        this.zi = 0.0;
        this.black = new int[3];
        this.black[0] = 0;
        this.black[1] = 0;
        this.black[2] = 0;
        this.red = new int[3];
        this.red[0] = 255;
        this.red[1] = 0;
        this.red[2] = 0;
        this.done = true;
        this.colors = new Object[200];
        int c = 255;
        for (i = 0; i < 50; ++i) {
            color = new int[]{0, 255 - c, c};
            this.colors[i] = color;
            c -= 5;
        }
        c = 255;
        for (i = 50; i < 100; ++i) {
            color = new int[]{255 - c, 255, 0};
            this.colors[i] = color;
            c -= 5;
        }
        c = 255;
        for (i = 100; i < 150; ++i) {
            color = new int[]{c, c, 255 - c};
            this.colors[i] = color;
            c -= 5;
        }
        c = 255;
        for (i = 150; i < 200; ++i) {
            color = new int[]{255 - c, 0, 255};
            this.colors[i] = color;
            c -= 5;
        }
    }

    public void setInsets(double sx, double sy, double w, double h) {
        this.startx = sx;
        this.starty = sy;
        this.width = w;
        this.height = h;
    }

    public static double comp_mult_real(double a, double b, double c, double d) {
        return a * c - b * d;
    }

    public static double comp_mult_imag(double a, double b, double c, double d) {
        return a * d + b * c;
    }

    public int mandelbrotTest(double a, double bi) {
        int number = 0;
        double z = 0.0;
        double zi = 0.0;
        while (number != 200 && Calculator.comp_magnitude(z, zi) < 2.0) {
            ++number;
            double atmp = Calculator.comp_mult_real(z, zi, z, zi);
            double btmp = Calculator.comp_mult_imag(z, zi, z, zi);
            z = atmp;
            zi = btmp;
            z += a;
            zi += bi;
        }
        if (number == 200) {
            return -1;
        }
        return number;
    }

    public boolean isDone() {
        return this.done;
    }

    public static double comp_magnitude(double a, double b) {
        return Math.sqrt(a * a + b * b);
    }

    public void run() {
        double dx = this.width / (double)this.sizex;
        double dy = this.height / (double)this.sizey;
        double z = this.startx;
        double zi = this.starty;
        this.done = false;
        System.out.println("Calculating...");
        for (int x = 0; x < this.sizex; ++x) {
            zi = this.starty;
            for (int y = 0; y < this.sizey; ++y) {
                int it = this.mandelbrotTest(z, zi);
                if (it != -1) {
                    this.raster.setPixel(x, y, (int[])this.colors[it]);
                } else {
                    this.raster.setPixel(x, y, this.black);
                }
                zi += dy;
            }
            if (x % 5 == 0) {
                this.parent.repaint();
            }
            z += dx;
        }
        this.done = true;
        System.out.println("Done!");
    }
}

