/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.cli.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;

public class MethodsCommand
implements CommandProvider {
    private static final String INSTRUMENTEDMETHODS = "org.bundlebee.weaver.instrumentedmethods";

    public void _bbmethods(CommandInterpreter commandInterpreter) {
        String argument = commandInterpreter.nextArgument();
        if (argument == null) {
            commandInterpreter.println((Object)this.getHelp());
        } else {
            if (argument.equals("get")) {
                commandInterpreter.println();
                this.println(commandInterpreter);
                commandInterpreter.println();
            }
            if (argument.equals("set")) {
                String propSet = commandInterpreter.nextArgument();
                if (propSet == null) {
                    commandInterpreter.println((Object)this.getHelp());
                } else {
                    commandInterpreter.println();
                    this.set(commandInterpreter, propSet);
                    commandInterpreter.println();
                }
            }
            if (argument.equals("load")) {
                String url = commandInterpreter.nextArgument();
                if (url == null) {
                    commandInterpreter.println((Object)this.getHelp());
                } else {
                    commandInterpreter.println();
                    this.load(commandInterpreter, url);
                    commandInterpreter.println();
                }
            }
        }
    }

    private void println(CommandInterpreter ci) {
        String instrumented = System.getProperty(INSTRUMENTEDMETHODS);
        if (instrumented != null) {
            ci.println((Object)("org.bundlebee.weaver.instrumentedmethods=" + instrumented));
        }
    }

    private void set(CommandInterpreter ci, String propSet) {
        String[] prop = propSet.split("=");
        if (prop.length == 2 && prop[0].trim().equals(INSTRUMENTEDMETHODS)) {
            System.setProperty(INSTRUMENTEDMETHODS, prop[1]);
        }
        ci.println((Object)("org.bundlebee.weaver.instrumentedmethods=" + System.getProperty(INSTRUMENTEDMETHODS)));
    }

    private void load(CommandInterpreter ci, String url) {
        String instrumented = System.getProperty(INSTRUMENTEDMETHODS);
        if (instrumented != null) {
            ci.println((Object)("loading from: " + url));
        }
        try {
            URL propsUrl = new URL(url);
            Properties properties = new Properties();
            properties.load(new FileInputStream(new File(propsUrl.getFile())));
            System.setProperty(INSTRUMENTEDMETHODS, properties.getProperty(INSTRUMENTEDMETHODS, instrumented));
            ci.println((Object)("org.bundlebee.weaver.instrumentedmethods=" + System.getProperty(INSTRUMENTEDMETHODS)));
        }
        catch (MalformedURLException ex) {
            ci.println((Object)(url + " is not a valid URL."));
        }
        catch (FileNotFoundException fnfe) {
            ci.println((Object)("File not found: " + url));
        }
        catch (IOException ioe) {
            ci.println((Object)("Could not open or read: " + url));
        }
    }

    public String getHelp() {
        return "\tbbmethods | get | set <property>  | load <java.net.URL> |  - gets/sets the istrumentedMethods property of the BundleBee grid node.\n";
    }
}

