/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.html;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.html.DefaultCssBuilder;
import ch.qos.logback.classic.html.DefaultThrowableRenderer;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.html.HTMLLayoutBase;
import ch.qos.logback.core.pattern.Converter;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLLayout
extends HTMLLayoutBase<LoggingEvent> {
    static final String DEFAULT_CONVERSION_PATTERN = "%date%thread%level%logger%mdc%msg";

    public HTMLLayout() {
        this.pattern = DEFAULT_CONVERSION_PATTERN;
        this.throwableRenderer = new DefaultThrowableRenderer();
        this.cssBuilder = new DefaultCssBuilder();
    }

    @Override
    protected Map<String, String> getDefaultConverterMap() {
        return PatternLayout.defaultConverterMap;
    }

    @Override
    public String doLayout(LoggingEvent event) {
        StringBuffer buf = new StringBuffer();
        this.handleTableClosing(buf);
        boolean odd = true;
        if ((this.counter++ & 1L) == 0L) {
            odd = false;
        }
        String level = event.getLevel().toString().toLowerCase();
        buf.append(LINE_SEP);
        buf.append("<tr class=\"");
        buf.append(level);
        if (odd) {
            buf.append(" odd\">");
        } else {
            buf.append(" even\">");
        }
        buf.append(LINE_SEP);
        for (Converter c = this.head; c != null; c = c.getNext()) {
            this.appendEventToBuffer(buf, c, event);
        }
        buf.append("</tr>");
        buf.append(LINE_SEP);
        if (event.getThrowableInformation() != null) {
            this.throwableRenderer.render(buf, event);
        }
        return buf.toString();
    }

    private void appendEventToBuffer(StringBuffer buf, Converter<LoggingEvent> c, LoggingEvent event) {
        buf.append("<td class=\"");
        buf.append(this.computeConverterName(c));
        buf.append("\">");
        buf.append(c.convert(event));
        buf.append("</td>");
        buf.append(LINE_SEP);
    }
}

