/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.examples.fractal;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import javax.swing.JFrame;
import org.bundlebee.examples.fractal.Calculator;

public class fraktal
extends JFrame
implements MouseListener {
    BufferedImage fractal;
    WritableRaster raster;
    Calculator calc;
    int mouse_x;
    int mouse_y;
    double x;
    double y;
    double width;
    double height;

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.mouse_x = e.getX();
        this.mouse_y = e.getY();
    }

    public void mouseReleased(MouseEvent e) {
        double tmpx = this.translateX(this.mouse_x);
        double tmpy = this.translateY(this.mouse_y);
        double tmp = this.translateX(e.getX());
        this.x = tmpx;
        this.y = tmpy;
        this.width = Math.abs(tmp - tmpx);
        this.height = 0.75 * this.width;
        while (!this.calc.isDone()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.calc = new Calculator(632, 453, this.raster, this);
        this.calc.setInsets(this.x, this.y, this.width, this.height);
        this.calc.start();
    }

    public double translateX(int ix) {
        return this.x + (double)ix / 632.0 * this.width;
    }

    public double translateY(int iy) {
        return this.y + (double)iy / 453.0 * this.height;
    }

    public fraktal(String[] args) {
        super("Mandelbrot");
        this.setSize(640, 480);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        Component graphics = new Component(){

            public void paint(Graphics g) {
                g.drawImage(fraktal.this.fractal, 0, 0, null);
            }
        };
        graphics.addMouseListener(this);
        this.getContentPane().add(graphics);
        this.fractal = new BufferedImage(632, 453, 1);
        this.raster = this.fractal.getRaster();
        System.out.println("Topleft corner of raster: " + this.raster.getMinX() + "," + this.raster.getMinY());
        System.out.println("Size of raster: " + this.raster.getWidth() + "," + this.raster.getHeight());
        this.show();
        this.calc = new Calculator(632, 453, this.raster, this);
        this.x = -1.5;
        this.y = -1.0;
        this.width = 2.0;
        this.height = 0.75 * this.width;
        if (args.length == 0) {
            this.calc.setInsets(-1.5, -1.0, 2.0, 1.5);
        }
        if (args.length == 3) {
            this.x = Double.parseDouble(args[0]);
            this.y = Double.parseDouble(args[1]);
            this.width = Double.parseDouble(args[2]);
            this.height = 0.75 * this.width;
            this.calc.setInsets(this.x, this.y, this.width, this.height);
        }
        System.out.println("Calculating rectangle: (" + this.x + "," + this.y + ") to (" + (this.x + this.width) + "," + (this.y + this.height) + ")");
        this.calc.start();
    }

    public static void main(String[] args) {
        new fraktal(args);
    }
}

