/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.spi.AppenderAttachable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppenderAttachableImpl<E>
implements AppenderAttachable<E> {
    private final List<Appender<E>> appenderList = new ArrayList<Appender<E>>();

    @Override
    public void addAppender(Appender<E> newAppender) {
        if (newAppender == null) {
            throw new IllegalArgumentException("Cannot null as an appener");
        }
        if (!this.appenderList.contains(newAppender)) {
            this.appenderList.add(newAppender);
        }
    }

    public int appendLoopOnAppenders(E e) {
        int size = 0;
        size = this.appenderList.size();
        for (int i = 0; i < size; ++i) {
            Appender<E> appender = this.appenderList.get(i);
            appender.doAppend(e);
        }
        return size;
    }

    @Override
    public Iterator iteratorForAppenders() {
        return this.appenderList.iterator();
    }

    @Override
    public Appender<E> getAppender(String name) {
        if (name == null) {
            return null;
        }
        int size = this.appenderList.size();
        for (int i = 0; i < size; ++i) {
            Appender<E> appender = this.appenderList.get(i);
            if (!name.equals(appender.getName())) continue;
            return appender;
        }
        return null;
    }

    @Override
    public boolean isAttached(Appender appender) {
        if (appender == null) {
            return false;
        }
        int size = this.appenderList.size();
        for (int i = 0; i < size; ++i) {
            Appender<E> a = this.appenderList.get(i);
            if (a != appender) continue;
            return true;
        }
        return false;
    }

    @Override
    public void detachAndStopAllAppenders() {
        int len = this.appenderList.size();
        for (int i = 0; i < len; ++i) {
            Appender<E> a = this.appenderList.get(i);
            a.stop();
        }
        this.appenderList.clear();
    }

    @Override
    public boolean detachAppender(Appender appender) {
        if (appender == null) {
            return false;
        }
        return this.appenderList.remove(appender);
    }

    @Override
    public Appender<E> detachAppender(String name) {
        if (name == null) {
            return null;
        }
        int size = this.appenderList.size();
        for (int i = 0; i < size; ++i) {
            if (!name.equals(this.appenderList.get(i).getName())) continue;
            return this.appenderList.remove(i);
        }
        return null;
    }
}

