/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.cli.impl;

import java.util.ArrayList;
import java.util.Collections;
import org.bundlebee.registry.directory.Bundle;
import org.bundlebee.registry.directory.Grid;
import org.bundlebee.registry.directory.Node;
import org.bundlebee.registry.impl.RegistryImpl;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;

public class StatusCommand
implements CommandProvider {
    public void _bbstatus(CommandInterpreter commandInterpreter) {
        String argument = commandInterpreter.nextArgument();
        if (argument == null) {
            Grid grid = RegistryImpl.getInstance().getGrid();
            commandInterpreter.println();
            this.println(commandInterpreter, grid);
            commandInterpreter.println();
            ArrayList nodeIds = new ArrayList(grid.getNodeIds());
            Collections.sort(nodeIds);
            for (Long id : nodeIds) {
                Node node = grid.getNode(id.longValue());
                this.println(commandInterpreter, node);
            }
        } else {
            try {
                Grid grid = RegistryImpl.getInstance().getGrid();
                Node node = grid.getNode(Long.parseLong(argument));
                if (node == null) {
                    commandInterpreter.println((Object)("BundleBee node " + argument + " not found."));
                }
                commandInterpreter.println();
                this.println(commandInterpreter, node);
                commandInterpreter.println();
                commandInterpreter.println((Object)("Bundles on node " + node.getId() + ":"));
                commandInterpreter.println();
                commandInterpreter.println((Object)"State\tBundle");
                ArrayList bundles = new ArrayList(node.getBundles());
                Collections.sort(bundles);
                for (Bundle bundle : bundles) {
                    this.println(commandInterpreter, bundle);
                }
            }
            catch (NumberFormatException e) {
                commandInterpreter.println((Object)("BundleBee node " + argument + " not found."));
            }
        }
    }

    private void println(CommandInterpreter ci, Bundle bundle) {
        ci.println((Object)(bundle.getStateDescription() + "\t" + bundle.getName()));
    }

    private void println(CommandInterpreter ci, Node node) {
        ci.print((Object)("BundleBee node " + node.getId()));
        if (node.isLocalNode()) {
            ci.print((Object)" (local)");
        }
        ci.println((Object)":");
        ci.println((Object)("\tAddress\t\t" + node.getPrivateAddressAndPort()));
        ci.println((Object)("\tBundles\t\t" + node.getBundles().size()));
        ci.println((Object)("\tManager URL\t" + node.getManagerURL()));
        ci.println((Object)("\tRepository URL\t" + node.getRepositoryURL()));
        ci.println((Object)("\tMemory\t\t" + (node.getFreeMemory() >> 10) + "kb of " + (node.getMaxMemory() >> 10) + "kb are free"));
    }

    private void println(CommandInterpreter ci, Grid grid) {
        ci.println((Object)("BundleBee grid with " + grid.getNodes().size() + " node(s)."));
    }

    public String getHelp() {
        return "\tbbstatus [nodeId] - shows the status of the BundleBee grid or a single node.\n";
    }
}

