/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.watchdog.impl;

import java.util.Timer;
import java.util.TimerTask;
import org.bundlebee.registry.Registry;
import org.bundlebee.registry.impl.RegistryImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class Activator
implements BundleActivator {
    private static Logger LOG = LoggerFactory.getLogger(Activator.class);
    public static final String ID = "org.bundlebee.watchdog";
    public static final Marker BUNDLE_MARKER = Activator.createBundleMarker();
    private static final int DELAY = 2000;
    private static final int PERIOD = 2000;
    private Timer timer;
    private long lastFreeMemory;
    private long lastMaxMemory;
    private double changeThreshold = 0.05;

    private static Marker createBundleMarker() {
        Marker bundleMarker = MarkerFactory.getMarker((String)ID);
        bundleMarker.add(MarkerFactory.getMarker((String)"IS_MARKER"));
        return bundleMarker;
    }

    public void start(BundleContext context) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting Watchdog Bundle...");
        }
        this.timer = new Timer("Watchdog Timer", true);
        this.timer.schedule(new TimerTask(){

            public void run() {
                Registry registry = RegistryImpl.getInstance();
                Runtime runtime = Runtime.getRuntime();
                long freeMemory = runtime.freeMemory();
                long maxMemory = runtime.maxMemory();
                if ((double)Math.abs(freeMemory - Activator.this.lastFreeMemory) > (double)maxMemory * Activator.this.changeThreshold || (double)Math.abs(maxMemory - Activator.this.lastMaxMemory) > (double)maxMemory * Activator.this.changeThreshold) {
                    registry.registerMemory(freeMemory, maxMemory);
                    Activator.this.lastFreeMemory = freeMemory;
                    Activator.this.lastMaxMemory = maxMemory;
                }
            }
        }, 2000L, 2000L);
    }

    public void stop(BundleContext context) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopping Watchdog Bundle...");
        }
        this.timer.cancel();
    }
}

