/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.util.OptionHelper;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLayoutAction<E>
extends Action {
    Layout<E> layout;
    boolean inError = false;

    @Override
    public void begin(InterpretationContext ec, String name, Attributes attributes) {
        this.inError = false;
        String className = attributes.getValue("class");
        try {
            this.layout = (Layout)OptionHelper.instantiateByClassName(className, Layout.class, this.context);
            this.layout.setContext(this.context);
            ec.pushObject(this.layout);
        }
        catch (Exception oops) {
            this.inError = true;
            this.addError("Could not create layout of type " + className + "].", oops);
        }
    }

    @Override
    public void end(InterpretationContext ec, String e) {
        Object o;
        if (this.inError) {
            return;
        }
        if (this.layout instanceof LifeCycle) {
            this.layout.start();
        }
        if ((o = ec.peekObject()) != this.layout) {
            this.addWarn("The object on the top the of the stack is not the layout pushed earlier.");
        } else {
            ec.popObject();
            try {
                Appender appender = (Appender)ec.peekObject();
                appender.setLayout(this.layout);
            }
            catch (Exception ex) {
                this.addError("Could not set the layout for containing appender.", ex);
            }
        }
    }

    public void finish(InterpretationContext ec) {
    }
}

