/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.registry.net;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bundlebee.registry.impl.RegistryImpl;
import org.bundlebee.registry.net.MultiCastMessageListener;
import org.bundlebee.registry.net.MultiCastMessageSource;
import org.bundlebee.registry.net.MultiCastNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Network {
    private static Logger LOG = LoggerFactory.getLogger(Network.class);
    private Set<MultiCastNode> multiCastNodes = Collections.synchronizedSet(new HashSet());
    private MultiCastMessageSource multiCastMessageSource;
    private MultiCastMessageListener multiCastMessageListener;

    public Network(MultiCastMessageSource multiCastMessageSource, MultiCastMessageListener multiCastMessageListener, long nodeId) throws IOException {
        this.multiCastMessageSource = multiCastMessageSource;
        this.multiCastMessageListener = multiCastMessageListener;
        this.initMultiCastNode(nodeId);
    }

    public void stop() {
        if (LOG.isInfoEnabled()) {
            LOG.info(RegistryImpl.BUNDLE_MARKER, "sending stop to multiCastNodes:");
        }
        for (MultiCastNode multiCastNode : this.multiCastNodes) {
            multiCastNode.stop();
        }
    }

    private void initMultiCastNode(long nodeId) throws IOException {
        MultiCastNode multiCastNode;
        if (LOG.isDebugEnabled()) {
            LOG.debug(RegistryImpl.BUNDLE_MARKER, "initMultiCastNode....");
        }
        if ((multiCastNode = new MultiCastNode(nodeId)).isRunning()) {
            this.addMultiCastNode(multiCastNode);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(RegistryImpl.BUNDLE_MARKER, "initMultiCastNode.... DONE.");
        }
    }

    private void addMultiCastNode(MultiCastNode multiCastNode) {
        boolean success = this.multiCastNodes.add(multiCastNode);
        if (success) {
            this.multiCastMessageSource.addMultiCastMessageListener(multiCastNode);
            multiCastNode.addMultiCastMessageListener(this.multiCastMessageListener);
        }
    }
}

