/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.manager.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.Servlet;
import org.bundlebee.carrier.Carrier;
import org.bundlebee.manager.Manager;
import org.bundlebee.manager.impl.Activator;
import org.bundlebee.manager.impl.BundleLifecycleServlet;
import org.bundlebee.manager.impl.ServiceMethodCallServlet;
import org.bundlebee.registry.impl.RegistryImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagerImpl
implements Manager {
    private static final Logger LOG = LoggerFactory.getLogger(ManagerImpl.class);
    public static final String ORG_BUNDLEBEE_MANAGER_ALIAS = "org.bundlebee.manager.alias";
    private static final String DEFAULT_BUNDLEBEE_MANAGER_ALIAS = "/bundlebee/manager";
    private static final String ORG_BUNDLEBEE_REGISTRY_LOCALADDRESS = "org.bundlebee.registry.localaddress";
    private static final String ORG_BUNDLEBEE_MANAGER_LOCALADDRESS = "org.bundlebee.manager.localaddress";
    private BundleContext bundleContext;
    private ServiceTracker carrierTracker;
    private ServiceTracker httpServiceTracker;
    private Integer port = null;
    private BundleListener bundleListener;
    private String localAddress = System.getProperty("org.bundlebee.manager.localaddress", System.getProperty("org.bundlebee.registry.localaddress", InetAddress.getLocalHost().getHostAddress()));

    public ManagerImpl(BundleContext bundleContext) throws InvalidSyntaxException, IOException {
        this.bundleContext = bundleContext;
        this.carrierTracker = new ServiceTracker(bundleContext, Carrier.class.getName(), null);
        this.carrierTracker.open();
        this.httpServiceTracker = new HttpServiceTracker(bundleContext, this);
        this.httpServiceTracker.open();
        this.bundleListener = new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                ManagerImpl.this.registerBundle(event.getBundle());
            }
        };
        bundleContext.addBundleListener(this.bundleListener);
        this.registerExistingBundles();
    }

    private void registerExistingBundles() {
        for (Bundle bundle : this.bundleContext.getBundles()) {
            this.registerBundle(bundle);
        }
    }

    private void unregisterExistingBundles() {
        for (Bundle bundle : this.bundleContext.getBundles()) {
            this.unregisterBundle(bundle);
        }
    }

    private void registerBundle(Bundle bundle) {
        RegistryImpl.getInstance().registerBundle(this.getSymbolicNameVersion(bundle), bundle.getState());
    }

    private String getSymbolicNameVersion(Bundle bundle) {
        return bundle.getSymbolicName() + "/" + bundle.getHeaders().get("Bundle-Version");
    }

    private void unregisterBundle(Bundle bundle) {
        RegistryImpl.getInstance().unregisterBundle(this.getSymbolicNameVersion(bundle));
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void stop() {
        this.httpServiceTracker.close();
        this.carrierTracker.close();
        this.bundleContext.removeBundleListener(this.bundleListener);
        this.unregisterExistingBundles();
    }

    public URL getManagerURL() {
        if (this.port == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(Activator.BUNDLE_MARKER, "Port is null");
            }
            return null;
        }
        try {
            return new URL("http://" + this.localAddress + ":" + this.port + this.getManagerAlias());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getManagerAlias() {
        return System.getProperty(ORG_BUNDLEBEE_MANAGER_ALIAS, DEFAULT_BUNDLEBEE_MANAGER_ALIAS);
    }

    public void install(String symbolicName, String version) throws BundleException {
        if (!this.isInstalled(symbolicName, version)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Trying to install bundle " + symbolicName + "/" + version);
            }
            Carrier carrier = (Carrier)this.carrierTracker.getService();
            String expression = "(&(symbolicname=" + symbolicName + ")(version=" + version + "))";
            carrier.deploy(expression, false);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Installed bundle " + symbolicName + "/" + version + " with no exception.");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Did not install bundle " + symbolicName + "/" + version + ", because it is already installed.");
        }
    }

    public void uninstall(String symbolicName, String version) throws BundleException {
        Bundle bundle = this.getBundle(symbolicName, version);
        if (bundle != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Trying to uninstall bundle " + symbolicName + "/" + version);
            }
            bundle.uninstall();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Uninstalled bundle " + symbolicName + "/" + version + " with no exception.");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Did not uninstall bundle " + symbolicName + "/" + version + ", because it does not seem to be installed.");
        }
    }

    public void start(String symbolicName, String version) throws BundleException {
        Bundle bundle = this.getBundle(symbolicName, version);
        if (bundle == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Bundle " + symbolicName + "/" + version + " cannot be started, as it is not installed, yet. Attempting installation.");
            }
            this.install(symbolicName, version);
            bundle = this.getBundle(symbolicName, version);
        }
        if (bundle != null) {
            if (bundle.getState() != 32) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Trying to start bundle " + symbolicName + "/" + version);
                }
                bundle.start();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Started bundle " + symbolicName + "/" + version + " with no exception.");
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("No need to start bundle " + symbolicName + "/" + version + " as it is already active.");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Did not start bundle " + symbolicName + "/" + version + ", because it is not installed.");
        }
    }

    public void stop(String symbolicName, String version) throws BundleException {
        Bundle bundle = this.getBundle(symbolicName, version);
        if (bundle != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Trying to stop bundle " + symbolicName + "/" + version);
            }
            bundle.stop();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stopped bundle " + symbolicName + "/" + version + " with no exception.");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Did not stop bundle " + symbolicName + "/" + version + ", because it is not installed.");
        }
    }

    private boolean isInstalled(String symbolicName, String version) {
        return this.getBundle(symbolicName, version) != null;
    }

    private Bundle getBundle(String symbolicName, String version) {
        Bundle[] installedBundles = this.bundleContext.getBundles();
        Bundle bundle = null;
        for (Bundle installedBundle : installedBundles) {
            String installedSymbolicname = installedBundle.getSymbolicName();
            Object installedVersion = installedBundle.getHeaders().get("Bundle-Version");
            if (!symbolicName.equals(installedSymbolicname) || !version.equals(installedVersion)) continue;
            bundle = installedBundle;
            break;
        }
        return bundle;
    }

    private static class HttpServiceTracker
    extends ServiceTracker {
        private static final int DEFAULT_PORT = 8080;
        private ManagerImpl manager;

        public HttpServiceTracker(BundleContext bundleContext, ManagerImpl manager) {
            super(bundleContext, HttpService.class.getName(), null);
            this.manager = manager;
        }

        public Object addingService(ServiceReference serviceReference) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(Activator.BUNDLE_MARKER, "addingService " + serviceReference);
            }
            HttpService httpService = (HttpService)this.manager.getBundleContext().getService(serviceReference);
            Integer port = (Integer)serviceReference.getProperty("http.port");
            if (port == null) {
                this.manager.port = 8080;
            } else {
                this.manager.port = port;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(Activator.BUNDLE_MARKER, "httpService " + httpService);
            }
            HttpContext defaultHttpContext = httpService.createDefaultHttpContext();
            if (LOG.isDebugEnabled()) {
                LOG.debug(Activator.BUNDLE_MARKER, "defaultHttpContext " + defaultHttpContext);
            }
            try {
                httpService.registerServlet(this.manager.getManagerAlias() + "/install", (Servlet)new BundleLifecycleServlet(){

                    public void post(String symbolicName, String version) throws BundleException {
                        HttpServiceTracker.this.manager.install(symbolicName, version);
                    }
                }, null, defaultHttpContext);
                httpService.registerServlet(this.manager.getManagerAlias() + "/uninstall", (Servlet)new BundleLifecycleServlet(){

                    public void post(String symbolicName, String version) throws BundleException {
                        HttpServiceTracker.this.manager.uninstall(symbolicName, version);
                    }
                }, null, defaultHttpContext);
                httpService.registerServlet(this.manager.getManagerAlias() + "/start", (Servlet)new BundleLifecycleServlet(){

                    public void post(String symbolicName, String version) throws BundleException {
                        HttpServiceTracker.this.manager.start(symbolicName, version);
                    }
                }, null, defaultHttpContext);
                httpService.registerServlet(this.manager.getManagerAlias() + "/stop", (Servlet)new BundleLifecycleServlet(){

                    public void post(String symbolicName, String version) throws BundleException {
                        HttpServiceTracker.this.manager.stop(symbolicName, version);
                    }
                }, null, defaultHttpContext);
                httpService.registerServlet(this.manager.getManagerAlias() + "/service", (Servlet)new ServiceMethodCallServlet(this.manager), null, defaultHttpContext);
                this.registerAtDistributedRegistry();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return httpService;
        }

        private void registerAtDistributedRegistry() {
            URL managerURL = this.manager.getManagerURL();
            if (managerURL != null) {
                RegistryImpl.getInstance().registerManager(managerURL);
            }
        }

        public void modifiedService(ServiceReference serviceReference, Object service) {
        }

        public void removedService(ServiceReference serviceReference, Object service) {
            this.unregisterFromDistributedRegistry();
            this.manager.port = null;
            HttpService httpService = (HttpService)service;
            httpService.unregister(this.manager.getManagerAlias() + "/install");
            httpService.unregister(this.manager.getManagerAlias() + "/uninstall");
            httpService.unregister(this.manager.getManagerAlias() + "/start");
            httpService.unregister(this.manager.getManagerAlias() + "/stop");
            httpService.unregister(this.manager.getManagerAlias() + "/service");
        }

        private void unregisterFromDistributedRegistry() {
            URL managerURL = this.manager.getManagerURL();
            if (managerURL != null) {
                RegistryImpl.getInstance().unregisterManager(managerURL);
            }
        }

        public synchronized void close() {
            this.manager.port = null;
            this.unregisterFromDistributedRegistry();
            super.close();
        }
    }
}

