/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.cli.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.bundlebee.registry.directory.Node;
import org.bundlebee.registry.impl.RegistryImpl;
import org.bundlebee.remoteservicecall.BundleLifecycleClient;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BundleLifecycleClientCommand {
    private BundleContext bundleContext;
    private BundleLifecycleClient.Method method;

    public BundleLifecycleClientCommand(BundleContext bundleContext, BundleLifecycleClient.Method method) {
        this.bundleContext = bundleContext;
        this.method = method;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    protected Set<URL> getManagerURLs(CommandInterpreter commandInterpreter) {
        HashSet<URL> managerURLs = new HashSet<URL>();
        String remoteNodeId = commandInterpreter.nextArgument();
        if (remoteNodeId == null) {
            managerURLs.addAll(RegistryImpl.getInstance().getGrid().getManagers());
        } else {
            URL url = this.getManagerURL(commandInterpreter, remoteNodeId);
            if (url != null) {
                managerURLs.add(url);
            }
            while ((remoteNodeId = commandInterpreter.nextArgument()) != null) {
                URL additionalURL = this.getManagerURL(commandInterpreter, remoteNodeId);
                if (additionalURL == null) continue;
                managerURLs.add(additionalURL);
            }
        }
        return managerURLs;
    }

    private URL getManagerURL(CommandInterpreter commandInterpreter, String remoteNodeId) {
        URL url = null;
        try {
            Long nodeId = Long.parseLong(remoteNodeId);
            Node node = RegistryImpl.getInstance().getGrid().getNode(nodeId.longValue());
            if (node != null) {
                if (node.getManagerURL() != null) {
                    url = node.getManagerURL();
                } else {
                    commandInterpreter.println((Object)("Node " + nodeId + " does not seem to have a manager URL."));
                }
            } else {
                commandInterpreter.println((Object)("Failed to find node with id " + nodeId));
            }
        }
        catch (NumberFormatException e) {
            commandInterpreter.println((Object)("Node id " + remoteNodeId + "  seems to be invalid."));
        }
        return url;
    }

    protected String getBundleName(CommandInterpreter commandInterpreter, String nameVersionOrBundleIdOrURL) {
        String nameVersion = nameVersionOrBundleIdOrURL;
        try {
            long bundleId = Long.parseLong(nameVersionOrBundleIdOrURL);
            Bundle bundle = this.bundleContext.getBundle(bundleId);
            if (bundle != null) {
                nameVersion = bundle.getSymbolicName() + "/" + bundle.getHeaders().get("Bundle-Version");
            }
        }
        catch (NumberFormatException e) {
            try {
                URL url = new URL(nameVersionOrBundleIdOrURL);
                Bundle bundle = this.getBundleContext().installBundle(url.toString());
                nameVersion = bundle.getSymbolicName() + "/" + bundle.getHeaders().get("Bundle-Version");
            }
            catch (MalformedURLException url) {
            }
            catch (BundleException e1) {
                commandInterpreter.println((Object)("Failed to install bundle locally: " + (Object)((Object)e1)));
                nameVersion = null;
            }
        }
        return nameVersion;
    }

    public String getHelp() {
        return "\tbb" + this.method.getMethod() + " symbolicname/version | localBundleId | url [nodeId]* - " + this.method.getMethod() + "s a bundle on all or specific nodes\n";
    }

    protected void execute(CommandInterpreter commandInterpreter) {
        String nameVersionOrBundleIdOrURL = commandInterpreter.nextArgument();
        if (nameVersionOrBundleIdOrURL == null) {
            commandInterpreter.print((Object)this.getHelp());
        } else {
            String nameVersion = this.getBundleName(commandInterpreter, nameVersionOrBundleIdOrURL);
            if (nameVersion != null) {
                this.execute(commandInterpreter, nameVersion);
            }
        }
    }

    private void execute(CommandInterpreter commandInterpreter, String nameVersion) {
        Set<URL> managerURLs = this.getManagerURLs(commandInterpreter);
        if (managerURLs.isEmpty()) {
            commandInterpreter.println((Object)"No valid nodes specified.");
        } else {
            commandInterpreter.println((Object)(this.method + "ing " + nameVersion + " ..."));
            for (URL url : managerURLs) {
                commandInterpreter.print((Object)("\ton " + url + ": "));
                try {
                    HttpURLConnection urlConnection = new BundleLifecycleClient().openConnection(url, this.method, nameVersion);
                    int responseCode = urlConnection.getResponseCode();
                    if (responseCode == 200) {
                        commandInterpreter.println((Object)"SUCCESS");
                        continue;
                    }
                    commandInterpreter.println((Object)("FAILURE - Code: " + responseCode));
                    this.printStream(commandInterpreter, urlConnection);
                }
                catch (IOException e) {
                    commandInterpreter.println((Object)"FAILURE");
                    commandInterpreter.printStackTrace((Throwable)e);
                }
            }
            commandInterpreter.println((Object)"Operation completed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printStream(CommandInterpreter commandInterpreter, HttpURLConnection urlConnection) {
        InputStream inputStream = null;
        try {
            inputStream = urlConnection.getErrorStream();
            if (inputStream == null) {
                inputStream = urlConnection.getInputStream();
            }
            if (inputStream != null) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "ASCII"));
                while ((line = reader.readLine()) != null) {
                    commandInterpreter.println((Object)line);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

