/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.common.exceptions;

import java.util.Set;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.common.util.OAuth2Utils;

public class InvalidScopeException
extends OAuth2Exception {
    public InvalidScopeException(String msg, Set<String> validScope) {
        this(msg);
        this.addAdditionalInformation("scope", OAuth2Utils.formatParameterList(validScope));
    }

    public InvalidScopeException(String msg) {
        super(msg);
    }

    @Override
    public String getOAuth2ErrorCode() {
        return "invalid_scope";
    }
}

