/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.jwt.assertion.impl;

import com.google.common.base.Strings;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import org.mitre.jwt.assertion.AssertionValidator;
import org.mitre.jwt.signer.service.JWTSigningAndValidationService;
import org.mitre.openid.connect.config.ConfigurationPropertiesBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="selfAssertionValidator")
public class SelfAssertionValidator
implements AssertionValidator {
    private static Logger logger = LoggerFactory.getLogger(SelfAssertionValidator.class);
    @Autowired
    private ConfigurationPropertiesBean config;
    @Autowired
    private JWTSigningAndValidationService jwtService;

    @Override
    public boolean isValid(JWT assertion) {
        JWTClaimsSet claims;
        if (!(assertion instanceof SignedJWT)) {
            return false;
        }
        try {
            claims = assertion.getJWTClaimsSet();
        }
        catch (ParseException e) {
            logger.debug("Invalid assertion claims");
            return false;
        }
        if (Strings.isNullOrEmpty((String)claims.getIssuer())) {
            logger.debug("No issuer for assertion, rejecting");
            return false;
        }
        if (!claims.getIssuer().equals(this.config.getIssuer())) {
            logger.debug("Issuer is not the same as this server, rejecting");
            return false;
        }
        return this.jwtService.validateSignature((SignedJWT)assertion);
    }
}

