/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.web;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.common.exceptions.InsufficientScopeException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;

public abstract class AuthenticationUtilities {
    public static void ensureOAuthScope(Authentication auth, String scope) {
        OAuth2Authentication oAuth2Authentication;
        if (auth instanceof OAuth2Authentication && ((oAuth2Authentication = (OAuth2Authentication)auth).getOAuth2Request().getScope() == null || !oAuth2Authentication.getOAuth2Request().getScope().contains(scope))) {
            throw new InsufficientScopeException("Insufficient scope", (Set)ImmutableSet.of((Object)scope));
        }
    }

    public static boolean isAdmin(Authentication auth) {
        for (GrantedAuthority grantedAuthority : auth.getAuthorities()) {
            if (!grantedAuthority.getAuthority().equals("ROLE_ADMIN")) continue;
            return true;
        }
        return false;
    }

    public static boolean hasRole(Authentication auth, String role) {
        for (GrantedAuthority grantedAuthority : auth.getAuthorities()) {
            if (!grantedAuthority.getAuthority().equals(role)) continue;
            return true;
        }
        return false;
    }
}

