/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.client.service.impl;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.mitre.jwt.signer.service.JWTSigningAndValidationService;
import org.mitre.oauth2.model.RegisteredClient;
import org.mitre.openid.connect.client.service.AuthRequestUrlBuilder;
import org.mitre.openid.connect.config.ServerConfiguration;
import org.springframework.security.authentication.AuthenticationServiceException;

public class SignedAuthRequestUrlBuilder
implements AuthRequestUrlBuilder {
    private JWTSigningAndValidationService signingAndValidationService;

    @Override
    public String buildAuthRequestUrl(ServerConfiguration serverConfig, RegisteredClient clientConfig, String redirectUri, String nonce, String state, Map<String, String> options, String loginHint) {
        JWSAlgorithm alg;
        JWTClaimsSet.Builder claims = new JWTClaimsSet.Builder();
        claims.claim("response_type", (Object)"code");
        claims.claim("client_id", (Object)clientConfig.getClientId());
        claims.claim("scope", (Object)Joiner.on((String)" ").join((Iterable)clientConfig.getScope()));
        claims.claim("redirect_uri", (Object)redirectUri);
        claims.claim("nonce", (Object)nonce);
        claims.claim("state", (Object)state);
        for (Map.Entry<String, String> option : options.entrySet()) {
            claims.claim(option.getKey(), (Object)option.getValue());
        }
        if (!Strings.isNullOrEmpty((String)loginHint)) {
            claims.claim("login_hint", (Object)loginHint);
        }
        if ((alg = clientConfig.getRequestObjectSigningAlg()) == null) {
            alg = this.signingAndValidationService.getDefaultSigningAlgorithm();
        }
        SignedJWT jwt = new SignedJWT(new JWSHeader(alg), claims.build());
        this.signingAndValidationService.signJwt(jwt, alg);
        try {
            URIBuilder uriBuilder = new URIBuilder(serverConfig.getAuthorizationEndpointUri());
            uriBuilder.addParameter("request", jwt.serialize());
            return uriBuilder.build().toString();
        }
        catch (URISyntaxException e) {
            throw new AuthenticationServiceException("Malformed Authorization Endpoint Uri", (Throwable)e);
        }
    }

    public JWTSigningAndValidationService getSigningAndValidationService() {
        return this.signingAndValidationService;
    }

    public void setSigningAndValidationService(JWTSigningAndValidationService signingAndValidationService) {
        this.signingAndValidationService = signingAndValidationService;
    }
}

