/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter;

import java.io.IOException;
import java.io.InputStream;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;

class ActivationMediaTypeFactory {
    private static final FileTypeMap fileTypeMap = ActivationMediaTypeFactory.loadFileTypeMapFromContextSupportModule();

    ActivationMediaTypeFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileTypeMap loadFileTypeMapFromContextSupportModule() {
        ClassPathResource mappingLocation = new ClassPathResource("org/springframework/mail/javamail/mime.types");
        if (mappingLocation.exists()) {
            InputStream inputStream = null;
            try {
                inputStream = mappingLocation.getInputStream();
                MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap(inputStream);
                return mimetypesFileTypeMap;
            }
            catch (IOException iOException) {
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return FileTypeMap.getDefaultFileTypeMap();
    }

    public static MediaType getMediaType(Resource resource) {
        String mediaType;
        String filename = resource.getFilename();
        if (filename != null && StringUtils.hasText((String)(mediaType = fileTypeMap.getContentType(filename)))) {
            return MediaType.parseMediaType(mediaType);
        }
        return null;
    }
}

