/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.jwt.assertion.impl;

import com.google.common.base.Strings;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.mitre.jwt.assertion.AssertionValidator;
import org.mitre.jwt.signer.service.JWTSigningAndValidationService;
import org.mitre.jwt.signer.service.impl.JWKSetCacheService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class WhitelistedIssuerAssertionValidator
implements AssertionValidator {
    private static Logger logger = LoggerFactory.getLogger(WhitelistedIssuerAssertionValidator.class);
    private Map<String, String> whitelist = new HashMap<String, String>();
    @Autowired
    private JWKSetCacheService jwkCache;

    public Map<String, String> getWhitelist() {
        return this.whitelist;
    }

    public void setWhitelist(Map<String, String> whitelist) {
        this.whitelist = whitelist;
    }

    @Override
    public boolean isValid(JWT assertion) {
        JWTClaimsSet claims;
        if (!(assertion instanceof SignedJWT)) {
            return false;
        }
        try {
            claims = assertion.getJWTClaimsSet();
        }
        catch (ParseException e) {
            logger.debug("Invalid assertion claims");
            return false;
        }
        if (Strings.isNullOrEmpty((String)claims.getIssuer())) {
            logger.debug("No issuer for assertion, rejecting");
            return false;
        }
        if (!this.whitelist.containsKey(claims.getIssuer())) {
            logger.debug("Issuer is not in whitelist, rejecting");
            return false;
        }
        String jwksUri = this.whitelist.get(claims.getIssuer());
        JWTSigningAndValidationService validator = this.jwkCache.getValidator(jwksUri);
        return validator.validateSignature((SignedJWT)assertion);
    }
}

