/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.uma.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.mitre.uma.model.Policy;

@Entity
@Table(name="resource_set")
@NamedQueries(value={@NamedQuery(name="ResourceSet.queryByOwner", query="select r from ResourceSet r where r.owner = :owner"), @NamedQuery(name="ResourceSet.queryByOwnerAndClient", query="select r from ResourceSet r where r.owner = :owner and r.clientId = :clientId"), @NamedQuery(name="ResourceSet.queryByClient", query="select r from ResourceSet r where r.clientId = :clientId"), @NamedQuery(name="ResourceSet.queryAll", query="select r from ResourceSet r")})
public class ResourceSet {
    public static final String QUERY_BY_OWNER = "ResourceSet.queryByOwner";
    public static final String QUERY_BY_OWNER_AND_CLIENT = "ResourceSet.queryByOwnerAndClient";
    public static final String QUERY_BY_CLIENT = "ResourceSet.queryByClient";
    public static final String QUERY_ALL = "ResourceSet.queryAll";
    public static final String PARAM_OWNER = "owner";
    public static final String PARAM_CLIENTID = "clientId";
    private Long id;
    private String name;
    private String uri;
    private String type;
    private Set<String> scopes = new HashSet<String>();
    private String iconUri;
    private String owner;
    private String clientId;
    private Collection<Policy> policies = new HashSet<Policy>();

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Basic
    @Column(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Basic
    @Column(name="uri")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @Basic
    @Column(name="rs_type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @Column(name="scope")
    @CollectionTable(name="resource_set_scope", joinColumns={@JoinColumn(name="owner_id")})
    public Set<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(Set<String> scopes) {
        this.scopes = scopes;
    }

    @Basic
    @Column(name="icon_uri")
    public String getIconUri() {
        return this.iconUri;
    }

    public void setIconUri(String iconUri) {
        this.iconUri = iconUri;
    }

    @Basic
    @Column(name="owner")
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Basic
    @Column(name="client_id")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="resource_set_id")
    public Collection<Policy> getPolicies() {
        return this.policies;
    }

    public void setPolicies(Collection<Policy> policies) {
        this.policies = policies;
    }

    public String toString() {
        return "ResourceSet [id=" + this.id + ", name=" + this.name + ", uri=" + this.uri + ", type=" + this.type + ", scopes=" + this.scopes + ", iconUri=" + this.iconUri + ", owner=" + this.owner + ", clientId=" + this.clientId + ", policies=" + this.policies + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = 31 * result + (this.iconUri == null ? 0 : this.iconUri.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        result = 31 * result + (this.policies == null ? 0 : this.policies.hashCode());
        result = 31 * result + (this.scopes == null ? 0 : this.scopes.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceSet other = (ResourceSet)obj;
        if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
            return false;
        }
        if (this.iconUri == null ? other.iconUri != null : !this.iconUri.equals(other.iconUri)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.owner == null ? other.owner != null : !this.owner.equals(other.owner)) {
            return false;
        }
        if (this.policies == null ? other.policies != null : !this.policies.equals(other.policies)) {
            return false;
        }
        if (this.scopes == null ? other.scopes != null : !this.scopes.equals(other.scopes)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }
}

