/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.service.impl;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.mitre.openid.connect.model.ApprovedSite;
import org.mitre.openid.connect.model.ClientStat;
import org.mitre.openid.connect.service.ApprovedSiteService;
import org.mitre.openid.connect.service.StatsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultStatsService
implements StatsService {
    @Autowired
    private ApprovedSiteService approvedSiteService;
    private Supplier<Map<String, Integer>> summaryCache = this.createSummaryCache();

    private Supplier<Map<String, Integer>> createSummaryCache() {
        return Suppliers.memoizeWithExpiration((Supplier)new Supplier<Map<String, Integer>>(){

            public Map<String, Integer> get() {
                return DefaultStatsService.this.computeSummaryStats();
            }
        }, (long)10L, (TimeUnit)TimeUnit.MINUTES);
    }

    public Map<String, Integer> getSummaryStats() {
        return (Map)this.summaryCache.get();
    }

    private Map<String, Integer> computeSummaryStats() {
        Collection allSites = this.approvedSiteService.getAll();
        HashSet<String> userIds = new HashSet<String>();
        HashSet<String> clientIds = new HashSet<String>();
        for (ApprovedSite approvedSite : allSites) {
            userIds.add(approvedSite.getUserId());
            clientIds.add(approvedSite.getClientId());
        }
        HashMap<String, Integer> e = new HashMap<String, Integer>();
        e.put("approvalCount", allSites.size());
        e.put("userCount", userIds.size());
        e.put("clientCount", clientIds.size());
        return e;
    }

    public ClientStat getCountForClientId(String clientId) {
        Collection approvedSites = this.approvedSiteService.getByClientId(clientId);
        ClientStat stat = new ClientStat();
        stat.setApprovedSiteCount(Integer.valueOf(approvedSites.size()));
        return stat;
    }

    public void resetCache() {
        this.summaryCache = this.createSummaryCache();
    }
}

