/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.web;

import java.util.Map;
import org.mitre.openid.connect.service.StatsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class RootController {
    public static final String API_URL = "api";
    @Autowired
    private StatsService statsService;

    @RequestMapping(value={"", "home", "index"})
    public String showHomePage(ModelMap m) {
        return "home";
    }

    @RequestMapping(value={"about", "about/"})
    public String showAboutPage(ModelMap m) {
        return "about";
    }

    @RequestMapping(value={"stats", "stats/"})
    public String showStatsPage(ModelMap m) {
        Map summary = this.statsService.getSummaryStats();
        m.put((Object)"statsSummary", (Object)summary);
        return "stats";
    }

    @RequestMapping(value={"contact", "contact/"})
    public String showContactPage(ModelMap m) {
        return "contact";
    }

    @PreAuthorize(value="hasRole('ROLE_USER')")
    @RequestMapping(value={"manage/**"})
    public String showClientManager(ModelMap m) {
        return "manage";
    }

    public StatsService getStatsService() {
        return this.statsService;
    }

    public void setStatsService(StatsService statsService) {
        this.statsService = statsService;
    }
}

